appModule.service('api', ['$http', '$q', '$rootScope', 'native', 'notices', 'log', "$translate", function ($http, $q, $rootScope, native, notices, log, $translate) {
    //加载配置文件
    var SERVER_CONFIG = null;
    var user = {};
    var isSessionExpired = true;
    var successCode = 0;
    var getConfig = function () {
        var deferred = $q.defer();
        if (SERVER_CONFIG !== null) {
            deferred.resolve();
        } else {
            native.getUCCDomain(function (uccServerIP) {
                if (!!uccServerIP) {
                    SERVER_CONFIG = {
                        cover_address: uccServerIP + "/microblog/theme/default/images/bbs/"
                    };
                }
                deferred.resolve();
            });
        }
        return deferred.promise;
    };

    function generateRequest(controller, action, url, method, body) {
        var req = {
            controller: controller,
            action: action,
            url: $.extend({
                v: 4,
                client_type: 'pc',
                lang: appModule.lang
            }, url),
            method: method
        };
        if (body) {
            req.body = body;
        }
        return req;
    }

    function sendRequest(request, onSuccess, onError) {
        var requestString = JSON.stringify(request);
        log.logInfo("send request:" + requestString);
        native.sendRequest(requestString, function (args) {
            if (args[0] === 0) {
                log.logInfo("send task_id:" + args[1]);
                native.addBBSEventHandler(args[1], function (data) {
                    log.logInfo("receive task_id:" + args[1]);
                    log.logInfo("receive BBS response:" + JSON.stringify(data));
                    var errorCode = data.errorCode;
                    if(errorCode !== successCode){
                        var errorKey = "common.error." + errorCode;
                        var translateMsg = $translate.instant(errorKey);
                        var errorMsg = translateMsg != errorKey ? translateMsg : $translate.instant("common.error.400");
                        onError(errorMsg,errorCode);
                    }else{
                        var response = data.response;
                        if (response.code === successCode) {
                            onSuccess(response.data);
                        } else {
                            log.logError("receive error code:" + response.code + "; error message:" + response.error);
                            var errorKey = "common.error." + response.code;
                            var translateMsg = $translate.instant(errorKey);
                            var errorMsg = translateMsg != errorKey ? translateMsg : response.error;
                            onError(errorMsg, response.code);
                        }
                    }
                    delete native.bbsCallback[args[1]];
                });
            }
        });
    }

    function convertReplyState(data) {
        return {
            unReplyCount: data['-1'],
            replyCount: data['0'] + data['1'] + data['2'],
            unAuditCount: data['0'],
            AuditedCount: data['1'] + data['2'],
            passedCount: data['1'],
            deniedCount: data['2'],
            totalCount: data['-1'] + data['0'] + data['1'] + data['2']
        }
    }

    var api = {
        errorCodes: {
            comment: {
                noNotice: 710701,
                noComment: 710704
            }
        },
        getCurrentUser: function () {
            return native.getUserInfo();
        },
        saveAccount: function (account, onSuccess, onError) {
            var request = generateRequest("bbs/board", "update.json", null, 1, {
                id: account.id,
                avatar: account.avatar,
                board_name: account.name
            });
            sendRequest(request, onSuccess, onError);
        },
        notifyError: function (options) {
            var option = null;
            if (typeof options == "string") {
                option = {
                    msg: options,
                    isShowCancel: false
                }
            } else {
                option = options;
            }
            $rootScope.$broadcast("onError", option);
        },
        notifyCloseError: function () {
            $rootScope.$broadcast("onCloseError");
        },
        sendNotice: function (notice, onSuccess, onError) {
            log.logInfo("prepare to send notice:" + notice.title);
            var request = generateRequest("bbs/bbs", "create.json", null, 1, notice);

            sendRequest(request, function (data) {
                log.logInfo('success to send notice,topic:' + notice.title + "; id=" + data.id);
                onSuccess(data);
            }, function (data) {
                log.logInfo('fail to send notice,topic:' + notice.title);
                onError(data);
            });
        },
        getNotices: function (accountId, criteria, onSuccess, onError) {
            var url = {
                count: 20,
                board_id: accountId
            };
            if (criteria.keyword) {
                url.keyword = criteria.keyword;
                if (!criteria.isNew && criteria.start) {
                    url.start = criteria.start;
                }
            } else {
                if (criteria.startTime) {
                    url.start_time = criteria.startTime;
                }
                if (criteria.editorId) {
                    url.editor_id = criteria.editorId;
                }
                if (criteria.isNew) {
                    url.since_id = criteria.lastNoticeId;
                } else {
                    url.max_id = criteria.lastNoticeId;
                }
                if (criteria.category) {
                    url.category = criteria.category;
                }
            }

            var request = generateRequest("bbs/bbs", "list_by_editor.json", url, 0);
            sendRequest(request, function (data) {
                var list = [];
                if (Array.isArray(data) && data.length > 0) {
                    $.each(data, function (index, item) {
                        var n = notices.notice.create();
                        notices.notice.convertFromFeedData(n, item);
                        // notices.notice.convertFromOAData(n, item);
                        list.push(n);
                    });
                }
                onSuccess(list);
            }, onError);
        },
        getAccounts: function (onSuccess, onError) {
            var url = {
                count: Number.MAX_SAFE_INTEGER
            };
            var request = generateRequest("bbs/board", "lists.json", url, 0);
            sendRequest(request, onSuccess, onError);
        },
        getReceiverAccounts: function (since, max, onSuccess, onError) {
            var url = {
                "start_time": since,
                "end_time": max,
                "count": 200
            };
            var request = generateRequest("bbs/board", "new_lists.json", url, 0);
            sendRequest(request, onSuccess, onError);
        },
        deleteNotice: function (n, onSuccess, onError) {
            var noticeId = n.id;
            if (!!noticeId) {
                var url = {
                    id: noticeId
                };
                if (n.type == 'preview') {
                    url.is_preview = 1;
                }
                var request = generateRequest("bbs/bbs", "destroy.json", url, 0);
                sendRequest(request, onSuccess, onError);
            } else {
                //删除草稿
                notices.removeNoticeDraft(n);
                onSuccess();
            }
        },
        search: function (action, key, orgIDs, onSuccess, onError) {
            var request = generateRequest("base/org", action + ".json", {count: 100, keyword: key, org_ids: orgIDs}, 0);
            if (this[action + "_taskID"]) {
                delete native.bbsCallback[this[action + "_taskID"]];
            }
            var requestString = JSON.stringify(request);
            log.logInfo("send request:" + requestString);
            var self = this;
            native.sendRequest(requestString, function (args) {
                if (args[0] === 0) {
                    self[action + "_taskID"] = args[1];
                    console.log("send request" + args[1]);
                    log.logInfo("send task_id:" + args[1]);
                    native.addBBSEventHandler(args[1], function (data) {
                        if(data.errorCode == successCode){
                            var response = data.response;
                            log.logInfo("receive task_id:" + args[1]);
                            log.logInfo("receive BBS response:" + JSON.stringify(response));
                            if (response.code === successCode) {
                                onSuccess(response.data);
                            } else {
                                onError(response.error);
                            }
                        }

                        delete native.bbsCallback[args[1]];
                    });
                }
            }, function (response) {
                log.logInfo("fail to load search result:" + response.error);
            });
        },
        getOneNotice: function (id, onSuccess, onError) {
            var request = generateRequest("bbs/bbs", "info.json", {id: id}, 0);
            sendRequest(request, onSuccess, onError);
        },
        getAccountUnreadCount: function (accountIds, onSuccess, onError) {
            var request = generateRequest("bbs/stat", "board_unread.json", null, 1, {board_ids: accountIds});
            sendRequest(request, onSuccess, onError);
        },
        getAccountAllUnreadCount: function (accountIds, onSuccess, onError) {
            var request = generateRequest("bbs/stat", "total_unread.json",{board_id: accountIds},0);
            sendRequest(request, onSuccess, onError);
        },
        getAvatarIcons: function (onSuccess, onError) {
            var request = generateRequest("bbs/pic", "board_avatar.json", {}, 0);
            sendRequest(request, onSuccess, onError);
        },
        getNoticeCovers: function (onSuccess, onError) {
            var request = generateRequest("bbs/pic", "bbs_thumb.json", {}, 0);
            sendRequest(request, onSuccess, onError);
        },
        removeNoticeCovers: function (id, onSuccess, onError) {
            var request = generateRequest("bbs/pic", "destroy.json", {id: id}, 0);
            sendRequest(request, onSuccess, onError);
        },
        getAccountAllEditors: function (accountId, onSuccess, onError) {
            var request = generateRequest("bbs/bbs", "editor_list_all.json", {board_id: accountId}, 0);
            sendRequest(request, onSuccess, onError);
        },
        uploadCustomizedCover: function (cover, onSuccess, onError) {
            var request = generateRequest("bbs/pic", "save_thumb.json", null, 1, cover);
            sendRequest(request, onSuccess, onError);
        },
        setNoticesRead: function (accountId, onSuccess, onError) {
            var request = generateRequest("bbs/bbs", "ackread_batch.json", {board_id: accountId}, 0);
            sendRequest(request, onSuccess, onError);
        },
        setOneNoticeRead: function (noticeId, onSuccess, onError) {
            var request = generateRequest('bbs/bbs', 'ackread.json', {feed_id: noticeId}, 0);
            sendRequest(request, onSuccess, onError);
        },
        sendComment: function (comment, onSuccess, onError) {
            var request = generateRequest('bbs/comment', 'create.json', null, 1, comment);
            sendRequest(request, onSuccess, onError);
        },
        getComments: function (noticeId, maxId, onSuccess, onError) {
            var url = {
                count: 20,
                bbs_id: noticeId,
                max_id: maxId
            };
            var request = generateRequest('bbs/comment', 'lists.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        removeComment: function (commentId, onSuccess, onError) {
            var url = {
                id: commentId
            };
            var request = generateRequest('bbs/comment', 'destroy.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        getOneComment: function (commentId, onSuccess, onError) {
            var url = {
                comment_id: commentId
            };
            var request = generateRequest('bbs/comment', 'info.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        auditFeedbacks: function (taskId, replyIds, status, opinion, onSuccess, onError) {
            var data = {
                bbs_id: taskId,
                sub_reply_ids: replyIds,
                status: status,
                audit_opinion: opinion
            };
            var request = generateRequest('bbs/bbstask', 'audit_batch.json', null, 1, data);
            sendRequest(request, onSuccess, onError);
        },
        auditFeedback:function(taskId,subReplyId,status,opinion,data,onSuccess,onError){
            var data = {
                bbs_id: taskId,
                sub_reply_id: subReplyId,
                status: status,
                audit_opinion: opinion,
                data:data
            };
            var request = generateRequest('bbs/bbstask', 'audit.json', null, 1, data);
            sendRequest(request, onSuccess, onError);
        },
        getCategoryData: function (accountId, categoryType, sinceId, maxId, onSuccess, onError) {
            var url = {
                board_id: accountId,
                count: 20
            };
            if (sinceId > 0 && sinceId == maxId) {
                url.feed_id = sinceId;
            } else {
                url.since_id = sinceId;
                url.max_id = maxId;
            }
            var request;
            if (categoryType) {
                url.feed_type = categoryType;
                request = generateRequest('bbs/feed', 'lists.json', url, 0);
            } else {
                request = generateRequest('bbs/feed', 'home.json', url, 0);
            }

            sendRequest(request, function (data) {
                var list = [];
                if (Array.isArray(data) && data.length > 0) {
                    if (sinceId == 0) {
                        for (var i = data.length - 1; i >= 0; i--) {
                            var n = notices.notice.create();
                            notices.notice.convertFromFeedData(n, data[i]);
                            list.push(n);
                        }
                    } else {
                        for (var i = 0; i <= data.length - 1; i++) {
                            var n = notices.notice.create();
                            notices.notice.convertFromFeedData(n, data[i]);
                            list.push(n);
                        }
                    }
                }
                onSuccess(list);
            }, onError);
        },
        getFeedIcon: function (type, onSuccess, onError) {
            onSuccess('theme/images/task/task_publish.png'); 
        },
        cancelTask: function (taskId, onSuccess, onError) {
            var data = {
                bbs_id: taskId
            };
            var request = generateRequest('bbs/bbstask', 'close.json', null, 1,data);
            sendRequest(request, onSuccess, onError);
        },
        getFeedbackList: function (taskId, criteria, onSuccess, onError) {
            var url = $.extend({
                bbs_id: taskId
            }, criteria);
            var request = generateRequest('bbs/bbstask', 'reply_lists.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        getSubTaskFeedbackList: function (taskId, subTaskId, criteria, onSuccess, onError) {
            var url = $.extend({
                bbs_id: taskId,
                sub_task_id: subTaskId
            }, criteria);
            var request = generateRequest('bbs/bbstask', 'reply_sub_lists.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        getReplyUsers: function (taskId,type,onSuccess, onError) {
            var url = {
                bbs_id: taskId,
                status:type
            };
            var request = generateRequest('bbs/bbstask', 'reply_user_lists.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        sendFeedbackReminder: function (taskId, onSuccess, onError) {
            var data = {
                bbs_id: taskId
            };
            var request = generateRequest('bbs/bbstask', 'remind.json', null, 1, data);
            sendRequest(request, onSuccess, onError);
        },
        getTaskTodoCount: function (accountId, onSuccess, onError) {
            var url = {
                board_id: accountId
            };
            var request = generateRequest('bbs/stat', 'task_todo_count.json', url, 0);
            sendRequest(request, onSuccess, onError);
        },
        getReplyStatics: function (taskId, subTaskId, onSuccess, onError) {
            var url = {
                bbs_id: taskId,
                sub_task_id: subTaskId
            };
            var request = generateRequest('bbs/stat', 'reply_stat.json', url, 0);
            sendRequest(request, function (data) {
                data.total_data = convertReplyState(data.total_data);
                var sub_task_data = data.sub_task_data.map(function (item) {
                    var newData = convertReplyState(item.data);
                    return $.extend({}, item, {data: newData});
                });
                data.sub_task_data = sub_task_data;
                onSuccess(data);
            }, onError);
        },
        getTaskPreAuditNumber:function(accountIds, bbsIds, onSuccess, onError){
            var data = {};
            if(accountIds){
                data.board_ids = accountIds;
            }
            if(bbsIds){
                data.bbs_ids = bbsIds;
            }
            var request = generateRequest('bbs/stat','total_unaudit.json',null,1,data);
            sendRequest(request,onSuccess,onError);
        }
    };


    return api;
}]);
